#ifndef _DRV_UART_H_
#define _DRV_UART_H_

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define  UART_LENGTH_TX	100	// 協議中最大的長度
#define  UART_LENGTH_RX	10	// 協議中最大的長度
struct DrvUartFormat_t
{
    unsigned char TxBuf[UART_LENGTH_TX];    // RW
    unsigned char RxBuf[UART_LENGTH_RX];    // RW
    unsigned char TxBufoffset;              // RW
    unsigned char RxBufoffset;              // RW
    unsigned char RxTimeOutCnt;
    unsigned char TxCycle;
    unsigned char TxLength;
    unsigned char RxLength;
    union {
		struct
		{
			unsigned char IsBusyTx : 1;  // R UART忙碌中，不能寫入新的數據
			unsigned char IsRxSuccess : 1;  // R UART有收到完整一幀數據，可以開始解析
		} b;
		unsigned char byte;
	} flag;
};
extern volatile struct DrvUartFormat_t DrvUart0Format;
extern volatile struct DrvUartFormat_t DrvUart1Format;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
void Drv_UART0_Init();     // ��l��
void Drv_UART1_Init();     // ��l��
void Drv_Uart0StartTx( unsigned char TxLength);
void Drv_Uart1StartTx( unsigned char TxLength);
unsigned char Drv_UART0WriteTxBuf(char* src,unsigned char startaddr, unsigned char len);
unsigned char Drv_UART1WriteTxBuf(char* src,unsigned char startaddr, unsigned char len);
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 預定義 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define SET_UARTn_ENABLE(n)	    { _uarten##n = 1;_rxen##n = 1;_txen##n = 1;_ur##n##f = 0;_txif##n = 0; _ur##n##e = 1;  _mf5f=0; _mf5e=1; _emi = 1;}
#define SET_UARTn_DISABLE(n)	{ _uarten##n = 0;_rxen##n = 0;_txen##n = 0;}


#define SET_UARTn_Format_D8_NONE_S1(n)		{ _u##n##cr1 = 0x00; _stops##n=0; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_EVEN_S1(n)		{ _u##n##cr1 = 0x20; _stops##n=0; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_ODD_S1(n)		{ _u##n##cr1 = 0x28; _stops##n=0; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D9_NONE_S1(n)		{ _u##n##cr1 = 0x40; _stops##n=0; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_EVEN_S1(n)		{ _u##n##cr1 = 0x60; _stops##n=0; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_ODD_S1(n)		{ _u##n##cr1 = 0x68; _stops##n=0; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop
#define SET_UARTn_Format_D8_NONE_S2(n)		{ _u##n##cr1 = 0x00; _stops##n=1; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_EVEN_S2(n)		{ _u##n##cr1 = 0x20; _stops##n=1; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_ODD_S2(n)		{ _u##n##cr1 = 0x28; _stops##n=1; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D9_NONE_S2(n)		{ _u##n##cr1 = 0x40; _stops##n=1; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_EVEN_S2(n)		{ _u##n##cr1 = 0x60; _stops##n=1; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_ODD_S2(n)		{ _u##n##cr1 = 0x68; _stops##n=1; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#define SET_UARTn_WAKEUP_ENABLE(n)				{ _wake##n  = 1;}
#define SET_UARTn_WAKEUP_DISABLE(n)				{ _wake##n  = 0;}
#define SET_UARTn_ADDRESS_ENABLE(n)				{ _adden##n = 1;}
#define SET_UARTn_ADDRESS_DISABLE(n)			{ _adden##n = 0;}
#define SET_UARTn_RECEIVER_IE_ENABLE(n)			{ _rie##n  = 1;} // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
#define SET_UARTn_RECEIVER_IE_DISABLE(n)		{ _rie##n  = 0;}
#define SET_UARTn_TRANSMITTER_IE_ENABLE(n)	    { _tiie##n = 1;} // TIDLE(無數據傳輸)置位，可置中斷標誌位
#define SET_UARTn_TRANSMITTER_IE_DISABLE(n)		{ _tiie##n = 0;}
#define SET_UARTn_TRANSMITTER_EMPTY_ENABLE(n)	{ _teie##n = 1;} // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
#define SET_UARTn_TRANSMITTER_EMPTY_DISABLE(n)	{ _teie##n = 0;}

#define SET_UARTn_FIFO_BYTE_1(n)	            { _rxftr##n##1 = 0; _rxftr##n##0 = 1;}    
#define SET_UARTn_FIFO_BYTE_2(n)	            { _rxftr##n##1 = 1; _rxftr##n##0 = 0;}
#define SET_UARTn_FIFO_BYTE_3(n)	            { _rxftr##n##1 = 1; _rxftr##n##0 = 1;}
#define SET_UARTn_FIFO_BYTE_4(n)	            { _rxftr##n##1 = 0; _rxftr##n##0 = 0;}

#if SYS_CLOCK_FREQ == 4000000
    #define SET_UARTn_BAUDRATE_300(n)			{ _brdl##n = 0x15;_brdh##n = 0x34; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_1200(n)			{ _brdl##n = 0x05;_brdh##n = 0x0d; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_2400(n)			{ _brdl##n = 0x82;_brdh##n = 0x06; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_4800(n)			{ _brdl##n = 0x41;_brdh##n = 0x03; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_9600(n)			{ _brdl##n = 0xa0;_brdh##n = 0x01; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_19200(n)		    { _brdl##n = 0xd0;_brdh##n = 0x00; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_38400(n)		    { _brdl##n = 0x68;_brdh##n = 0x00; _ufcr##n=0x08;}
    #define SET_UARTn_BAUDRATE_250000(n)		{ _brdl##n = 0x10;_brdh##n = 0x00; _ufcr##n=0x00;}
    
#endif
#if SYS_CLOCK_FREQ == 8000000
    #define SET_UARTn_BAUDRATE_300(n)			{ _brdl##n = 0x6a;_brdh##n = 0x0a; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_1200(n)			{ _brdl##n = 0x0a;_brdh##n = 0x1a; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_2400(n)			{ _brdl##n = 0x05;_brdh##n = 0x0d; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_4800(n)			{ _brdl##n = 0x82;_brdh##n = 0x06; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_9600(n)			{ _brdl##n = 0x41;_brdh##n = 0x03; _ufcr##n=0x18;}
    #define SET_UARTn_BAUDRATE_19200(n)		    { _brdl##n = 0xa0;_brdh##n = 0x01; _ufcr##n=0x28;}
    #define SET_UARTn_BAUDRATE_250000(n)		{ _brdl##n = 0x20;_brdh##n = 0x00; _ufcr##n=0x00;}
#endif
#if SYS_CLOCK_FREQ == 12000000
 	#define	SET_UARTn_BAUDRATE_300(n)			{ _brdl##n = 0x40;_brdh##n = 0x9c; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_1200(n)			{ _brdl##n = 0x10;_brdh##n = 0x27; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_2400(n)			{ _brdl##n = 0x88;_brdh##n = 0x13; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_4800(n)			{ _brdl##n = 0xc4;_brdh##n = 0x09; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_9600(n)			{ _brdl##n = 0xe2;_brdh##n = 0x04; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_19200(n)		    { _brdl##n = 0x71;_brdh##n = 0x02; _ufcr##n=0x00;}
    #define SET_UARTn_BAUDRATE_250000(n)		{ _brdl##n = 0x30;_brdh##n = 0x00; _ufcr##n=0x00;}
#endif

#endif
